/*
 * Decompiled with CFR 0.152.
 */
package sms.soap;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import sms.soap.Carpeta;
import sms.soap.Documento;
import sms.util.Util;

public class CarpetaDoc
extends Carpeta {
    private String path;

    public CarpetaDoc(String nombre, String directorio) {
        super(nombre);
        this.path = directorio;
        File d = new File(this.path);
        if (!d.exists()) {
            try {
                d.mkdirs();
            }
            catch (Exception E) {
                System.err.println("\tERROR: No se puede crear el directorio " + this.path + ":" + E.getMessage());
            }
        }
    }

    public void borraCarpetaDoc() {
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public long getNumeroElementos() {
        try {
            return new File(this.getPath()).list().length;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public boolean contieneDocumento(Documento documento) throws Exception {
        File f = new File(String.valueOf(this.getPath()) + Util.getSEPARADOR() + documento.getNombreArchivo());
        return f.exists();
    }

    public boolean contieneNumeroReferencia(Documento documento) throws Exception {
        String part1 = String.valueOf(documento.getCodigoServidor()) + "-" + documento.getCodigoTipoDocumento() + "-" + documento.getVersionTipoDocumento() + "-";
        String part2 = "-" + documento.getNumeroReferencia();
        final String nombre1 = part1.toLowerCase();
        final String nombre2A = String.valueOf(part2.toLowerCase()) + ".";
        final String nombre2B = String.valueOf(part2.toLowerCase()) + "-";
        File dir = new File(this.getPath());
        String[] found = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File d, String fileName) {
                String name = fileName.toLowerCase();
                return name.endsWith(".xml") && name.indexOf(nombre1) >= 0 && (name.indexOf(nombre2A) >= 0 || name.indexOf(nombre2B) >= 0);
            }
        });
        return found.length > 0;
    }

    public void mueveDocumento(Documento documento) throws Exception {
        this.mueveDocumento(documento, false);
    }

    public void mueveDocumento(Documento documento, boolean sobreEscribe) throws Exception {
        File f = new File(String.valueOf(this.getPath()) + Util.getSEPARADOR() + documento.getNombreArchivo());
        if (f.exists() && !sobreEscribe) {
            try {
                int i = 0;
                f = null;
                while ((f = new File(String.valueOf(this.getPath()) + Util.getSEPARADOR() + this.getNombre() + "-" + ++i + "-" + documento.getNombreArchivo())).exists()) {
                }
            }
            catch (Exception E) {
                E.printStackTrace();
            }
        }
        File archivoOriginal = documento.getArchivoOrigen();
        boolean agrego = false;
        boolean borro = false;
        try {
            documento.getDocXML().saveToFile(f);
            agrego = true;
            if (archivoOriginal != null && !archivoOriginal.getCanonicalPath().equals(f.getCanonicalPath())) {
                System.gc();
                archivoOriginal.delete();
            }
            borro = true;
        }
        catch (Exception E) {
            if (agrego && !borro) {
                System.gc();
                documento.getArchivoOrigen().delete();
            }
            throw new Exception(E.getMessage());
        }
        documento.setCarpeta(this);
        documento.setArchivoOrigen(f);
    }

    public int getNumeroDocumentos() {
        File dir = new File(this.getPath());
        File[] d = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory() && f.getName().toLowerCase().endsWith(".xml");
            }
        });
        return d.length;
    }

    public Documento[] getDocumentos() {
        File dir = new File(this.getPath());
        File[] d = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return !f.isDirectory();
            }
        });
        if (d == null) {
            return new Documento[0];
        }
        Documento[] ret = new Documento[d.length];
        int i = 0;
        while (i < d.length) {
            try {
                ret[i] = new Documento(d[i], this);
            }
            catch (Exception E) {
                ret[i] = null;
                try {
                    System.err.println("\tError recorriendo documentos en la carpeta " + this);
                    System.err.println("\tNo se reconoce el archivo " + d[i].getCanonicalPath() + " como un documento valido");
                    System.err.println(E.getMessage());
                    if (!new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "invalidos").exists()) {
                        new File(String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "invalidos").mkdirs();
                    }
                    Util.newFile(d[i].getCanonicalPath(), String.valueOf(Util.getPATH()) + Util.getSEPARADOR() + "xml" + Util.getSEPARADOR() + "invalidos" + Util.getSEPARADOR() + d[i].getName());
                    Util.deleteFile(d[i].getCanonicalPath());
                    System.err.println("\t=> Moviendo documento [" + d[i].getName() + "] a [" + Util.getPATH() + "\\xml\\invalidos].-\n\n");
                }
                catch (Exception E3) {
                    System.err.println(E3.getMessage());
                }
            }
            ++i;
        }
        return ret;
    }
}

