/*
 * Decompiled with CFR 0.152.
 */
package emisor.schema.impl.runtime;

final class IdentityHashSet {
    private Object[] table = new Object[191];
    private int count;
    private int threshold = 57;
    private static final float loadFactor = 0.3f;
    private static final int initialCapacity = 191;

    public boolean contains(Object key) {
        Object[] tab = this.table;
        int index = (System.identityHashCode(key) & Integer.MAX_VALUE) % tab.length;
        Object e;
        while ((e = tab[index]) != null) {
            if (e == key) {
                return true;
            }
            index = (index + 1) % tab.length;
        }
        return false;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Object[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Object[] newMap = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldMap[i] == null) continue;
            int index = (System.identityHashCode(oldMap[i]) & Integer.MAX_VALUE) % newMap.length;
            while (newMap[index] != null) {
                index = (index + 1) % newMap.length;
            }
            newMap[index] = oldMap[i];
        }
        this.threshold = (int)((float)newCapacity * 0.3f);
        this.table = newMap;
    }

    public boolean add(Object newObj) {
        Object existing;
        if (this.count >= this.threshold) {
            this.rehash();
        }
        Object[] tab = this.table;
        int index = (System.identityHashCode(newObj) & Integer.MAX_VALUE) % tab.length;
        while ((existing = tab[index]) != null) {
            if (existing == newObj) {
                return false;
            }
            index = (index + 1) % tab.length;
        }
        tab[index] = newObj;
        ++this.count;
        return true;
    }
}

